/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Optional;
import net.caffeinemc.mods.sodium.api.config.ConfigEntryPoint;
import net.caffeinemc.mods.sodium.api.config.ConfigState;
import net.caffeinemc.mods.sodium.api.config.StorageEventHandler;
import net.caffeinemc.mods.sodium.api.config.option.OptionFlag;
import net.caffeinemc.mods.sodium.api.config.option.OptionImpact;
import net.caffeinemc.mods.sodium.api.config.option.Range;
import net.caffeinemc.mods.sodium.api.config.structure.ConfigBuilder;
import net.caffeinemc.mods.sodium.api.config.structure.EnumOptionBuilder;
import net.caffeinemc.mods.sodium.api.config.structure.ModOptionsBuilder;
import net.caffeinemc.mods.sodium.api.config.structure.OptionBuilder;
import net.caffeinemc.mods.sodium.api.config.structure.OptionPageBuilder;
import net.caffeinemc.mods.sodium.client.SodiumClientMod;
import net.caffeinemc.mods.sodium.client.compatibility.environment.OsUtils;
import net.caffeinemc.mods.sodium.client.compatibility.workarounds.Workarounds;
import net.caffeinemc.mods.sodium.client.gl.arena.staging.MappedStagingBuffer;
import net.caffeinemc.mods.sodium.client.gl.device.RenderDevice;
import net.caffeinemc.mods.sodium.client.gui.FullscreenResolutionRange;
import net.caffeinemc.mods.sodium.client.gui.GUIScaleRange;
import net.caffeinemc.mods.sodium.client.gui.SodiumOptions;
import net.caffeinemc.mods.sodium.client.gui.options.control.ControlValueFormatterImpls;
import net.caffeinemc.mods.sodium.client.render.chunk.DeferMode;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.QuadSplittingMode;
import net.caffeinemc.mods.sodium.client.services.PlatformRuntimeInformation;
import net.minecraft.class_1011;
import net.minecraft.class_1041;
import net.minecraft.class_10537;
import net.minecraft.class_10539;
import net.minecraft.class_1060;
import net.minecraft.class_1084;
import net.minecraft.class_12253;
import net.minecraft.class_12393;
import net.minecraft.class_2561;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_313;
import net.minecraft.class_315;
import net.minecraft.class_3300;
import net.minecraft.class_4061;
import net.minecraft.class_4063;
import net.minecraft.class_4066;
import net.minecraft.class_7172;
import net.minecraft.class_9927;
import org.jspecify.annotations.Nullable;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;

public class SodiumConfigBuilder
implements ConfigEntryPoint {
    private static final class_2960 SODIUM_ICON = class_2960.method_60655((String)"sodium", (String)"textures/gui/config-icon.png");
    private static final SodiumOptions DEFAULTS = SodiumOptions.defaults();
    private final class_315 vanillaOpts;
    private final StorageEventHandler vanillaStorage;
    private final SodiumOptions sodiumOpts;
    private final StorageEventHandler sodiumStorage;
    private final @Nullable class_1041 window;

    public SodiumConfigBuilder() {
        class_310 minecraft = class_310.method_1551();
        this.window = minecraft.method_22683();
        this.vanillaOpts = minecraft.field_1690;
        this.vanillaStorage = this.vanillaOpts == null ? null : () -> {
            this.vanillaOpts.method_1640();
            SodiumClientMod.logger().info("Flushed changes to Minecraft configuration");
        };
        this.sodiumOpts = SodiumClientMod.options();
        this.sodiumStorage = () -> {
            try {
                SodiumOptions.writeToDisk(this.sodiumOpts);
            }
            catch (IOException e) {
                throw new RuntimeException("Couldn't save configuration changes", e);
            }
            SodiumClientMod.logger().info("Flushed changes to Sodium configuration");
        };
    }

    private class_313 getMonitor() {
        if (this.window == null) {
            return null;
        }
        return this.window.method_20831();
    }

    public static void registerIcon(class_1060 textureManager) {
        textureManager.method_65876(SODIUM_ICON, (class_10537)new SodiumLogo());
    }

    @Override
    public void registerConfigEarly(ConfigBuilder builder) {
        new SodiumConfigBuilder().buildEarlyConfig(builder);
    }

    @Override
    public void registerConfigLate(ConfigBuilder builder) {
        new SodiumConfigBuilder().buildFullConfig(builder);
    }

    private static ModOptionsBuilder createModOptionsBuilder(ConfigBuilder builder) {
        return builder.registerOwnModOptions().setName("Sodium").setIcon(SODIUM_ICON).formatVersion(version -> {
            String[] result = version.splitWithDelimiters("\\+", 2);
            return result[0];
        });
    }

    private void buildEarlyConfig(ConfigBuilder builder) {
        SodiumConfigBuilder.createModOptionsBuilder(builder).addPage(builder.createOptionPage().setName((class_2561)class_2561.method_43471((String)"sodium.options.pages.performance")).addOptionGroup(builder.createOptionGroup().addOption(this.buildNoErrorContextOption(builder))));
    }

    private void buildFullConfig(ConfigBuilder builder) {
        SodiumConfigBuilder.createModOptionsBuilder(builder).setColorTheme(builder.createColorTheme().setFullThemeRGB(-7019309, -3342866, -8741218)).addPage(this.buildGeneralPage(builder)).addPage(this.buildQualityPage(builder)).addPage(this.buildPerformancePage(builder)).addPage(this.buildAdvancedPage(builder));
    }

    private OptionPageBuilder buildGeneralPage(ConfigBuilder builder) {
        OptionPageBuilder generalPage = builder.createOptionPage().setName((class_2561)class_2561.method_43471((String)"sodium.options.pages.general"));
        generalPage.addOptionGroup(builder.createOptionGroup().addOption(builder.createIntegerOption(class_2960.method_60654((String)"sodium:general.render_distance")).setStorageHandler(this.vanillaStorage).setName((class_2561)class_2561.method_43471((String)"options.renderDistance")).setTooltip((class_2561)class_2561.method_43471((String)"sodium.options.view_distance.tooltip")).setValueFormatter(ControlValueFormatterImpls.translateVariable("options.chunks")).setRange(2, 32, 1).setDefaultValue(12).setBinding(arg_0 -> ((class_7172)this.vanillaOpts.method_42503()).method_41748(arg_0), () -> ((class_7172)this.vanillaOpts.method_42503()).method_41753()).setImpact(OptionImpact.HIGH).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD)).addOption(builder.createIntegerOption(class_2960.method_60654((String)"sodium:general.simulation_distance")).setStorageHandler(this.vanillaStorage).setName((class_2561)class_2561.method_43471((String)"options.simulationDistance")).setTooltip((class_2561)class_2561.method_43471((String)"sodium.options.simulation_distance.tooltip")).setValueFormatter(ControlValueFormatterImpls.translateVariable("options.chunks")).setRange(5, 32, 1).setDefaultValue(12).setBinding(arg_0 -> ((class_7172)this.vanillaOpts.method_42510()).method_41748(arg_0), () -> ((class_7172)this.vanillaOpts.method_42510()).method_41753()).setImpact(OptionImpact.HIGH).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD)).addOption(builder.createIntegerOption(class_2960.method_60654((String)"sodium:general.gamma")).setStorageHandler(this.vanillaStorage).setName((class_2561)class_2561.method_43471((String)"options.gamma")).setTooltip((class_2561)class_2561.method_43471((String)"sodium.options.brightness.tooltip")).setValueFormatter(ControlValueFormatterImpls.brightness()).setRange(0, 100, 1).setDefaultValue(50).setBinding(value -> this.vanillaOpts.method_42473().method_41748((Object)((double)value.intValue() * 0.01)), () -> (int)((Double)this.vanillaOpts.method_42473().method_41753() / 0.01))));
        generalPage.addOptionGroup(builder.createOptionGroup().addOption(builder.createIntegerOption(class_2960.method_60654((String)"sodium:general.gui_scale")).setStorageHandler(this.vanillaStorage).setName((class_2561)class_2561.method_43471((String)"options.guiScale")).setTooltip((class_2561)class_2561.method_43471((String)"sodium.options.gui_scale.tooltip")).setValueFormatter(ControlValueFormatterImpls.guiScale()).setValidatorProvider(state -> {
            int savedValue = state.readIntOption(class_2960.method_60654((String)"sodium:general.gui_scale"));
            int realMax = this.window.method_4476(0, class_310.method_1551().method_1573());
            int presentationMax = Math.max(savedValue, realMax);
            return new GUIScaleRange(presentationMax);
        }, ConfigState.UPDATE_ON_REBUILD, ConfigState.UPDATE_ON_APPLY).setDefaultValue(0).setBinding(arg_0 -> ((class_7172)this.vanillaOpts.method_42474()).method_41748(arg_0), () -> ((class_7172)this.vanillaOpts.method_42474()).method_41753())).addOption(builder.createBooleanOption(class_2960.method_60654((String)"sodium:general.fullscreen")).setStorageHandler(this.vanillaStorage).setName((class_2561)class_2561.method_43471((String)"options.fullscreen")).setTooltip((class_2561)class_2561.method_43471((String)"sodium.options.fullscreen.tooltip")).setDefaultValue(false).setBinding(value -> {
            this.vanillaOpts.method_42447().method_41748(value);
            if (this.window.method_4498() != ((Boolean)this.vanillaOpts.method_42447().method_41753()).booleanValue()) {
                this.window.method_4500();
                this.vanillaOpts.method_42447().method_41748((Object)this.window.method_4498());
            }
        }, () -> ((class_7172)this.vanillaOpts.method_42447()).method_41753())).addOption(builder.createIntegerOption(class_2960.method_60654((String)"sodium:general.fullscreen_resolution")).setStorageHandler(this.vanillaStorage).setName((class_2561)class_2561.method_43471((String)"options.fullscreen.resolution")).setTooltip((class_2561)class_2561.method_43471((String)"sodium.options.fullscreen_resolution.tooltip")).setValueFormatter(ControlValueFormatterImpls.resolution()).setValidator(new FullscreenResolutionRange()).setDefaultValue(0).setBinding(value -> {
            class_313 monitor = this.getMonitor();
            if (monitor != null) {
                this.window.method_4505(0 == value ? Optional.empty() : Optional.of(monitor.method_1620(value - 1)));
            }
        }, () -> {
            class_313 monitor = this.getMonitor();
            if (monitor == null) {
                return 0;
            }
            Optional optional = this.window.method_4511();
            return optional.map(videoMode -> monitor.method_1619(videoMode) + 1).orElse(0);
        }).setEnabledProvider(state -> {
            class_313 monitor = this.getMonitor();
            if (monitor == null || monitor.method_1621() <= 0) {
                return false;
            }
            OsUtils.OperatingSystem os = OsUtils.getOs();
            return (os == OsUtils.OperatingSystem.WIN || os == OsUtils.OperatingSystem.MAC) && state.readBooleanOption(class_2960.method_60654((String)"sodium:general.fullscreen"));
        }, new class_2960[]{class_2960.method_60654((String)"sodium:general.fullscreen")}).setFlags(OptionFlag.REQUIRES_VIDEOMODE_RELOAD)).addOption(builder.createBooleanOption(class_2960.method_60654((String)"sodium:general.vsync")).setStorageHandler(this.vanillaStorage).setName((class_2561)class_2561.method_43471((String)"options.vsync")).setTooltip((class_2561)class_2561.method_43471((String)"sodium.options.v_sync.tooltip")).setDefaultValue(true).setBinding(arg_0 -> ((class_7172)this.vanillaOpts.method_42433()).method_41748(arg_0), () -> ((class_7172)this.vanillaOpts.method_42433()).method_41753())).addOption(builder.createIntegerOption(class_2960.method_60654((String)"sodium:general.framerate_limit")).setStorageHandler(this.vanillaStorage).setName((class_2561)class_2561.method_43471((String)"options.framerateLimit")).setTooltip((class_2561)class_2561.method_43471((String)"sodium.options.fps_limit.tooltip")).setValueFormatter(ControlValueFormatterImpls.fpsLimit()).setRange(10, 260, 10).setDefaultValue(60).setBinding(arg_0 -> ((class_7172)this.vanillaOpts.method_42524()).method_41748(arg_0), () -> ((class_7172)this.vanillaOpts.method_42524()).method_41753())));
        generalPage.addOptionGroup(builder.createOptionGroup().addOption(builder.createEnumOption(class_2960.method_60654((String)"sodium:general.attack_indicator"), class_4061.class).setStorageHandler(this.vanillaStorage).setName((class_2561)class_2561.method_43471((String)"options.attackIndicator")).setTooltip((class_2561)class_2561.method_43471((String)"sodium.options.attack_indicator.tooltip")).setDefaultValue(class_4061.field_18152).setElementNameProvider(class_4061::method_76522).setBinding(arg_0 -> ((class_7172)this.vanillaOpts.method_42565()).method_41748(arg_0), () -> ((class_7172)this.vanillaOpts.method_42565()).method_41753())).addOption(builder.createBooleanOption(class_2960.method_60654((String)"sodium:general.autosave_indicator")).setStorageHandler(this.vanillaStorage).setName((class_2561)class_2561.method_43471((String)"options.autosaveIndicator")).setTooltip((class_2561)class_2561.method_43471((String)"sodium.options.autosave_indicator.tooltip")).setDefaultValue(true).setBinding(arg_0 -> ((class_7172)this.vanillaOpts.method_42452()).method_41748(arg_0), () -> ((class_7172)this.vanillaOpts.method_42452()).method_41753())));
        return generalPage;
    }

    private OptionPageBuilder buildQualityPage(ConfigBuilder builder) {
        OptionPageBuilder qualityPage = builder.createOptionPage().setName((class_2561)class_2561.method_43471((String)"sodium.options.pages.quality"));
        qualityPage.addOptionGroup(builder.createOptionGroup().addOption(builder.createBooleanOption(class_2960.method_60654((String)"sodium:quality.graphics")).setStorageHandler(this.vanillaStorage).setName((class_2561)class_2561.method_43471((String)"options.improvedTransparency")).setTooltip((class_2561)class_2561.method_43471((String)"options.improvedTransparency.tooltip")).setDefaultValue(false).setBinding(arg_0 -> ((class_7172)this.vanillaOpts.method_75337()).method_41748(arg_0), () -> ((class_7172)this.vanillaOpts.method_75337()).method_41753()).setImpact(OptionImpact.HIGH).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD)));
        qualityPage.addOptionGroup(builder.createOptionGroup().addOption(builder.createEnumOption(class_2960.method_60654((String)"sodium:quality.clouds"), class_4063.class).setStorageHandler(this.vanillaStorage).setName((class_2561)class_2561.method_43471((String)"options.renderClouds")).setTooltip((class_2561)class_2561.method_43471((String)"sodium.options.clouds_quality.tooltip")).setElementNameProvider(EnumOptionBuilder.nameProviderFrom(new class_2561[]{class_2561.method_43471((String)"options.off"), class_2561.method_43471((String)"options.clouds.fast"), class_2561.method_43471((String)"options.clouds.fancy")})).setDefaultValue(class_4063.field_18164).setBinding(value -> {
            class_276 framebuffer;
            this.vanillaOpts.method_42528().method_41748(value);
            if (class_310.method_29611() && (framebuffer = class_310.method_1551().field_1769.method_29364()) != null) {
                RenderSystem.getDevice().createCommandEncoder().clearColorAndDepthTextures(framebuffer.method_30277(), -1, framebuffer.method_30278(), 1.0);
            }
        }, () -> (class_4063)this.vanillaOpts.method_42528().method_41753()).setImpact(OptionImpact.LOW)).addOption(builder.createIntegerOption(class_2960.method_60654((String)"sodium:quality.render_cloud_distance")).setStorageHandler(this.vanillaStorage).setName((class_2561)class_2561.method_43471((String)"options.renderCloudsDistance")).setTooltip((class_2561)class_2561.method_43471((String)"sodium.options.clouds_distance.tooltip")).setRange(2, 128, 2).setDefaultValue(128).setBinding(value -> {
            this.vanillaOpts.method_71270().method_41748(value);
            class_310.method_1551().field_1769.method_62196().method_62166();
        }, () -> (Integer)this.vanillaOpts.method_71270().method_41753()).setImpact(OptionImpact.LOW).setValueFormatter(ControlValueFormatterImpls.translateVariable("options.chunks"))).addOption(builder.createIntegerOption(class_2960.method_60654((String)"sodium:quality.weather")).setStorageHandler(this.vanillaStorage).setName((class_2561)class_2561.method_43471((String)"options.weatherRadius")).setTooltip((class_2561)class_2561.method_43471((String)"options.weatherRadius.tooltip")).setDefaultValue(10).setRange(new Range(3, 10, 1)).setValueFormatter(ControlValueFormatterImpls.number()).setBinding(arg_0 -> ((class_7172)this.vanillaOpts.method_75333()).method_41748(arg_0), () -> ((class_7172)this.vanillaOpts.method_75333()).method_41753()).setImpact(OptionImpact.LOW)).addOption(builder.createBooleanOption(class_2960.method_60654((String)"sodium:quality.leaves")).setStorageHandler(this.vanillaStorage).setName((class_2561)class_2561.method_43471((String)"options.cutoutLeaves")).setTooltip((class_2561)class_2561.method_43471((String)"options.cutoutLeaves.tooltip")).setDefaultValue(true).setBinding(arg_0 -> ((class_7172)this.vanillaOpts.method_75334()).method_41748(arg_0), () -> ((class_7172)this.vanillaOpts.method_75334()).method_41753()).setImpact(OptionImpact.MEDIUM).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD)).addOption(builder.createEnumOption(class_2960.method_60654((String)"sodium:quality.particles"), class_4066.class).setStorageHandler(this.vanillaStorage).setName((class_2561)class_2561.method_43471((String)"options.particles")).setTooltip((class_2561)class_2561.method_43471((String)"sodium.options.particle_quality.tooltip")).setElementNameProvider(EnumOptionBuilder.nameProviderFrom(new class_2561[]{class_2561.method_43471((String)"options.particles.all"), class_2561.method_43471((String)"options.particles.decreased"), class_2561.method_43471((String)"options.particles.minimal")})).setDefaultValue(class_4066.field_18197).setBinding(arg_0 -> ((class_7172)this.vanillaOpts.method_42475()).method_41748(arg_0), () -> ((class_7172)this.vanillaOpts.method_42475()).method_41753()).setImpact(OptionImpact.MEDIUM)).addOption(builder.createBooleanOption(class_2960.method_60654((String)"sodium:quality.ao")).setStorageHandler(this.vanillaStorage).setName((class_2561)class_2561.method_43471((String)"options.ao")).setTooltip((class_2561)class_2561.method_43471((String)"sodium.options.smooth_lighting.tooltip")).setDefaultValue(true).setBinding(arg_0 -> ((class_7172)this.vanillaOpts.method_41792()).method_41748(arg_0), () -> ((class_7172)this.vanillaOpts.method_41792()).method_41753()).setImpact(OptionImpact.LOW).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD)).addOption(builder.createIntegerOption(class_2960.method_60654((String)"sodium:quality.biome_blend")).setStorageHandler(this.vanillaStorage).setName((class_2561)class_2561.method_43471((String)"options.biomeBlendRadius")).setValueFormatter(ControlValueFormatterImpls.biomeBlend()).setTooltip((class_2561)class_2561.method_43471((String)"sodium.options.biome_blend.tooltip")).setRange(0, 7, 1).setDefaultValue(2).setBinding(arg_0 -> ((class_7172)this.vanillaOpts.method_41805()).method_41748(arg_0), () -> ((class_7172)this.vanillaOpts.method_41805()).method_41753()).setImpact(OptionImpact.LOW).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD)).addOption(builder.createIntegerOption(class_2960.method_60654((String)"sodium:quality.entity_distance")).setStorageHandler(this.vanillaStorage).setName((class_2561)class_2561.method_43471((String)"options.entityDistanceScaling")).setValueFormatter(ControlValueFormatterImpls.percentage()).setTooltip((class_2561)class_2561.method_43471((String)"sodium.options.entity_distance.tooltip")).setRange(50, 500, 25).setDefaultValue(100).setBinding(value -> this.vanillaOpts.method_42517().method_41748((Object)((double)value.intValue() / 100.0)), () -> Math.round(((Double)this.vanillaOpts.method_42517().method_41753()).floatValue() * 100.0f)).setImpact(OptionImpact.HIGH)).addOption(builder.createBooleanOption(class_2960.method_60654((String)"sodium:quality.entity_shadows")).setStorageHandler(this.vanillaStorage).setName((class_2561)class_2561.method_43471((String)"options.entityShadows")).setTooltip((class_2561)class_2561.method_43471((String)"sodium.options.entity_shadows.tooltip")).setDefaultValue(true).setBinding(arg_0 -> ((class_7172)this.vanillaOpts.method_42435()).method_41748(arg_0), () -> ((class_7172)this.vanillaOpts.method_42435()).method_41753()).setImpact(OptionImpact.MEDIUM)).addOption(builder.createBooleanOption(class_2960.method_60654((String)"sodium:quality.vignette")).setStorageHandler(this.vanillaStorage).setName((class_2561)class_2561.method_43471((String)"options.vignette")).setTooltip((class_2561)class_2561.method_43471((String)"options.vignette.tooltip")).setDefaultValue(true).setBinding(arg_0 -> ((class_7172)this.vanillaOpts.method_75335()).method_41748(arg_0), () -> ((class_7172)this.vanillaOpts.method_75335()).method_41753())).addOption(builder.createIntegerOption(class_2960.method_60654((String)"sodium:quality.fade_time")).setStorageHandler(this.vanillaStorage).setName((class_2561)class_2561.method_43471((String)"options.chunkFade")).setTooltip((class_2561)class_2561.method_43471((String)"options.chunkFade.tooltip")).setDefaultValue(750).setValueFormatter(ControlValueFormatterImpls.chunkFade()).setRange(new Range(0, 2000, 50)).setBinding(fade -> this.vanillaOpts.method_76253().method_41748((Object)((double)fade.intValue() / 1000.0)), () -> (int)((Double)this.vanillaOpts.method_76253().method_41753() * 1000.0))));
        qualityPage.addOptionGroup(builder.createOptionGroup().addOption(builder.createIntegerOption(class_2960.method_60654((String)"sodium:quality.mipmap_levels")).setStorageHandler(this.vanillaStorage).setName((class_2561)class_2561.method_43471((String)"options.mipmapLevels")).setValueFormatter(ControlValueFormatterImpls.multiplier()).setTooltip((class_2561)class_2561.method_43471((String)"sodium.options.mipmap_levels.tooltip")).setRange(0, 4, 1).setDefaultValue(4).setBinding(arg_0 -> ((class_7172)this.vanillaOpts.method_42563()).method_41748(arg_0), () -> ((class_7172)this.vanillaOpts.method_42563()).method_41753()).setImpact(OptionImpact.MEDIUM).setFlags(OptionFlag.REQUIRES_ASSET_RELOAD)));
        qualityPage.addOptionGroup(builder.createOptionGroup().addOption(builder.createEnumOption(class_2960.method_60654((String)"sodium:quality.filtering_mode"), class_12393.class).setStorageHandler(this.vanillaStorage).setName((class_2561)class_2561.method_43471((String)"options.textureFiltering")).setTooltip(i -> class_2561.method_43471((String)("options.textureFiltering." + i.name().toLowerCase(Locale.ROOT) + ".tooltip"))).setElementNameProvider(name -> class_2561.method_43471((String)("options.textureFiltering." + name.name().toLowerCase(Locale.ROOT)))).setDefaultValue(class_12393.field_64664).setBinding(arg_0 -> ((class_7172)this.vanillaOpts.method_76747()).method_41748(arg_0), () -> ((class_7172)this.vanillaOpts.method_76747()).method_41753()).setImpact(OptionImpact.MEDIUM).setFlags(new OptionFlag[]{OptionFlag.REQUIRES_ASSET_RELOAD})).addOption(builder.createIntegerOption(class_2960.method_60654((String)"sodium:quality.anisotropy_bit")).setStorageHandler(this.vanillaStorage).setName((class_2561)class_2561.method_43471((String)"options.maxAnisotropy")).setRange(new Range(0, 3, 1)).setTooltip((class_2561)class_2561.method_43471((String)"options.maxAnisotropy.tooltip")).setDefaultValue(0).setValueFormatter(ControlValueFormatterImpls.anisotropyBit()).setBinding(arg_0 -> ((class_7172)this.vanillaOpts.method_76247()).method_41748(arg_0), () -> ((class_7172)this.vanillaOpts.method_76247()).method_41753()).setImpact(OptionImpact.MEDIUM).setFlags(OptionFlag.REQUIRES_ASSET_RELOAD).setEnabledProvider(i -> i.readEnumOption(class_2960.method_60654((String)"sodium:quality.filtering_mode"), class_12393.class) == class_12393.field_64665, new class_2960[]{class_2960.method_60654((String)"sodium:quality.filtering_mode")})));
        return qualityPage;
    }

    private OptionPageBuilder buildPerformancePage(ConfigBuilder builder) {
        OptionPageBuilder performancePage = builder.createOptionPage().setName((class_2561)class_2561.method_43471((String)"sodium.options.pages.performance"));
        performancePage.addOptionGroup(builder.createOptionGroup().addOption(builder.createIntegerOption(class_2960.method_60654((String)"sodium:performance.chunk_update_threads")).setStorageHandler(this.sodiumStorage).setName((class_2561)class_2561.method_43471((String)"sodium.options.chunk_update_threads.name")).setValueFormatter(ControlValueFormatterImpls.quantityOrDisabled(v -> class_2561.method_43469((String)"sodium.options.chunk_update_threads.value", (Object[])new Object[]{v}), (class_2561)class_2561.method_43471((String)"sodium.options.default"))).setTooltip((class_2561)class_2561.method_43471((String)"sodium.options.chunk_update_threads.tooltip")).setRange(0, Runtime.getRuntime().availableProcessors(), 1).setDefaultValue(SodiumConfigBuilder.DEFAULTS.performance.chunkBuilderThreads).setBinding(value -> {
            this.sodiumOpts.performance.chunkBuilderThreads = value;
        }, () -> this.sodiumOpts.performance.chunkBuilderThreads).setImpact(OptionImpact.HIGH).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD)).addOption(builder.createEnumOption(class_2960.method_60654((String)"sodium:performance.always_defer_chunk_updates"), DeferMode.class).setStorageHandler(this.sodiumStorage).setName((class_2561)class_2561.method_43471((String)"sodium.options.defer_chunk_updates.name")).setTooltip((class_2561)class_2561.method_43471((String)"sodium.options.defer_chunk_updates.tooltip")).setDefaultValue(SodiumConfigBuilder.DEFAULTS.performance.chunkBuildDeferMode).setBinding(value -> {
            this.sodiumOpts.performance.chunkBuildDeferMode = value;
        }, () -> this.sodiumOpts.performance.chunkBuildDeferMode).setImpact(OptionImpact.HIGH).setFlags(new OptionFlag[]{OptionFlag.REQUIRES_RENDERER_UPDATE})));
        performancePage.addOptionGroup(builder.createOptionGroup().addOption(builder.createBooleanOption(class_2960.method_60654((String)"sodium:performance.use_block_face_culling")).setStorageHandler(this.sodiumStorage).setName((class_2561)class_2561.method_43471((String)"sodium.options.use_block_face_culling.name")).setTooltip((class_2561)class_2561.method_43471((String)"sodium.options.use_block_face_culling.tooltip")).setDefaultValue(SodiumConfigBuilder.DEFAULTS.performance.useBlockFaceCulling).setBinding(value -> {
            this.sodiumOpts.performance.useBlockFaceCulling = value;
        }, () -> this.sodiumOpts.performance.useBlockFaceCulling).setImpact(OptionImpact.MEDIUM).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD)).addOption(builder.createBooleanOption(class_2960.method_60654((String)"sodium:performance.use_fog_occlusion")).setStorageHandler(this.sodiumStorage).setName((class_2561)class_2561.method_43471((String)"sodium.options.use_fog_occlusion.name")).setTooltip((class_2561)class_2561.method_43471((String)"sodium.options.use_fog_occlusion.tooltip")).setDefaultValue(SodiumConfigBuilder.DEFAULTS.performance.useFogOcclusion).setBinding(value -> {
            this.sodiumOpts.performance.useFogOcclusion = value;
        }, () -> this.sodiumOpts.performance.useFogOcclusion).setImpact(OptionImpact.MEDIUM).setFlags(OptionFlag.REQUIRES_RENDERER_UPDATE)).addOption(builder.createBooleanOption(class_2960.method_60654((String)"sodium:performance.use_entity_culling")).setStorageHandler(this.sodiumStorage).setName((class_2561)class_2561.method_43471((String)"sodium.options.use_entity_culling.name")).setTooltip((class_2561)class_2561.method_43471((String)"sodium.options.use_entity_culling.tooltip")).setDefaultValue(SodiumConfigBuilder.DEFAULTS.performance.useEntityCulling).setBinding(value -> {
            this.sodiumOpts.performance.useEntityCulling = value;
        }, () -> this.sodiumOpts.performance.useEntityCulling).setImpact(OptionImpact.MEDIUM)).addOption(builder.createBooleanOption(class_2960.method_60654((String)"sodium:performance.animate_only_visible_textures")).setStorageHandler(this.sodiumStorage).setName((class_2561)class_2561.method_43471((String)"sodium.options.animate_only_visible_textures.name")).setTooltip((class_2561)class_2561.method_43471((String)"sodium.options.animate_only_visible_textures.tooltip")).setDefaultValue(SodiumConfigBuilder.DEFAULTS.performance.animateOnlyVisibleTextures).setBinding(value -> {
            this.sodiumOpts.performance.animateOnlyVisibleTextures = value;
        }, () -> this.sodiumOpts.performance.animateOnlyVisibleTextures).setImpact(OptionImpact.HIGH).setFlags(OptionFlag.REQUIRES_RENDERER_UPDATE)).addOption(this.buildNoErrorContextOption(builder)).addOption(builder.createEnumOption(class_2960.method_60654((String)"sodium:performance.inactivity_fps_limit"), class_9927.class).setStorageHandler(this.vanillaStorage).setName((class_2561)class_2561.method_43471((String)"options.inactivityFpsLimit")).setElementNameProvider(class_9927::method_76526).setTooltip(state -> state == class_9927.field_52744 ? class_2561.method_43471((String)"options.inactivityFpsLimit.afk.tooltip") : class_2561.method_43471((String)"options.inactivityFpsLimit.minimized.tooltip")).setDefaultValue(class_9927.field_52744).setBinding(arg_0 -> ((class_7172)this.vanillaOpts.method_61970()).method_41748(arg_0), () -> ((class_7172)this.vanillaOpts.method_61970()).method_41753())));
        if (PlatformRuntimeInformation.getInstance().isDevelopmentEnvironment()) {
            performancePage.addOptionGroup(builder.createOptionGroup().addOption(builder.createEnumOption(class_2960.method_60654((String)"sodium:performance.quad_splitting"), QuadSplittingMode.class).setStorageHandler(this.sodiumStorage).setName((class_2561)class_2561.method_43471((String)"sodium.options.quad_splitting.name")).setTooltip((class_2561)class_2561.method_43471((String)"sodium.options.quad_splitting.tooltip")).setImpact(OptionImpact.MEDIUM).setDefaultValue(SodiumConfigBuilder.DEFAULTS.performance.quadSplittingMode).setBinding(value -> {
                this.sodiumOpts.performance.quadSplittingMode = value;
            }, () -> this.sodiumOpts.performance.quadSplittingMode).setEnabled(SodiumClientMod.options().debug.terrainSortingEnabled).setFlags(new OptionFlag[]{OptionFlag.REQUIRES_RENDERER_RELOAD})));
        }
        return performancePage;
    }

    private OptionBuilder buildNoErrorContextOption(ConfigBuilder builder) {
        return builder.createBooleanOption(class_2960.method_60654((String)"sodium:performance.use_no_error_context")).setStorageHandler(this.sodiumStorage).setName((class_2561)class_2561.method_43471((String)"sodium.options.use_no_error_context.name")).setTooltip((class_2561)class_2561.method_43471((String)"sodium.options.use_no_error_context.tooltip")).setDefaultValue(SodiumConfigBuilder.DEFAULTS.performance.useNoErrorGLContext).setBinding(value -> {
            this.sodiumOpts.performance.useNoErrorGLContext = value;
        }, () -> this.sodiumOpts.performance.useNoErrorGLContext).setEnabledProvider(state -> {
            GLCapabilities capabilities = GL.getCapabilities();
            return (capabilities.OpenGL46 || capabilities.GL_KHR_no_error) && !Workarounds.isWorkaroundEnabled(Workarounds.Reference.NO_ERROR_CONTEXT_UNSUPPORTED);
        }, new class_2960[0]).setImpact(OptionImpact.LOW).setFlags(OptionFlag.REQUIRES_GAME_RESTART);
    }

    private OptionPageBuilder buildAdvancedPage(ConfigBuilder builder) {
        OptionPageBuilder advancedPage = builder.createOptionPage().setName((class_2561)class_2561.method_43471((String)"sodium.options.pages.advanced"));
        boolean isPersistentMappingSupported = MappedStagingBuffer.isSupported(RenderDevice.INSTANCE);
        advancedPage.addOptionGroup(builder.createOptionGroup().addOption(builder.createBooleanOption(class_2960.method_60654((String)"sodium:advanced.use_persistent_mapping")).setStorageHandler(this.sodiumStorage).setName((class_2561)class_2561.method_43471((String)"sodium.options.use_persistent_mapping.name")).setTooltip((class_2561)class_2561.method_43471((String)"sodium.options.use_persistent_mapping.tooltip")).setDefaultValue(SodiumConfigBuilder.DEFAULTS.advanced.useAdvancedStagingBuffers).setBinding(value -> {
            this.sodiumOpts.advanced.useAdvancedStagingBuffers = value;
        }, () -> this.sodiumOpts.advanced.useAdvancedStagingBuffers).setEnabled(isPersistentMappingSupported).setImpact(OptionImpact.MEDIUM).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD)));
        advancedPage.addOptionGroup(builder.createOptionGroup().addOption(builder.createIntegerOption(class_2960.method_60654((String)"sodium:advanced.cpu_render_ahead_limit")).setStorageHandler(this.sodiumStorage).setName((class_2561)class_2561.method_43471((String)"sodium.options.cpu_render_ahead_limit.name")).setValueFormatter(ControlValueFormatterImpls.translateVariable("sodium.options.cpu_render_ahead_limit.value")).setTooltip((class_2561)class_2561.method_43471((String)"sodium.options.cpu_render_ahead_limit.tooltip")).setRange(0, 9, 1).setDefaultValue(SodiumConfigBuilder.DEFAULTS.advanced.cpuRenderAheadLimit).setBinding(value -> {
            this.sodiumOpts.advanced.cpuRenderAheadLimit = value;
        }, () -> this.sodiumOpts.advanced.cpuRenderAheadLimit)));
        return advancedPage;
    }

    static class SodiumLogo
    extends class_10537 {
        public SodiumLogo() {
            super(SODIUM_ICON);
        }

        public class_10539 method_65809(class_3300 resourceManager) throws IOException {
            try (InputStream inputStream = SodiumConfigBuilder.class.getResourceAsStream("/config-icon.png");){
                class_10539 class_105392 = new class_10539(class_1011.method_4309((InputStream)inputStream), new class_1084(false, false, class_12253.field_64076, 0.1f));
                return class_105392;
            }
        }
    }
}

